import time

class RemainingTime:
    def __init__(self, n_iter, smoothing_coef=0.9):
        self.n_iter = n_iter
        self.smoothing_coef = smoothing_coef

        self.average_time = None
        self._start = None
        self._end = None

    def start_each_iter(self):
        self._start = time.time()

    def end_each_iter(self):
        self._end = time.time()
        self.average_time = (self._end - self._start)  if self.average_time is None \
            else (self._end - self._start) * (1 - self.smoothing_coef) + self.average_time * self.smoothing_coef
        self.n_iter -= 1
        print('average_time = {}s'.format(self.average_time),
              'remaining time = {}h'.format(self.n_iter * self.average_time / 3600))
